#ifndef VRPN_GENERIC_SERVER_OBJECT_H
#define VRPN_GENERIC_SERVER_OBJECT_H

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>

#include "vrpn_Configure.h"
#include "vrpn_Connection.h"
#include "vrpn_Button.h"
#include "vrpn_Tracker.h"
#include "vrpn_Analog.h"
#include "vrpn_iOSDevice.h" // iOS Device

const int VRPN_GSO_MAX_TRACKERS =             100;
const int VRPN_GSO_MAX_BUTTONS =              100;
const int VRPN_GSO_MAX_ANALOG =               8;

class vrpn_Generic_Server_Object {
public:
  vrpn_Generic_Server_Object(vrpn_Connection *connection_to_use, const char *config_file_name = "vrpn.cfg", int port = vrpn_DEFAULT_LISTEN_PORT_NO, bool be_verbose = false, bool bail_on_open_error = false);
  ~vrpn_Generic_Server_Object();

  void mainloop(void);
  inline bool doing_okay(void) const { return d_doing_okay; }

protected:
  vrpn_Connection *connection;          //< Connection to communicate on
  bool            d_doing_okay;         //< Is the object working okay?
  bool            verbose;              //< Should we print lots of info?
  bool            d_bail_on_open_error; //< Should we bail if we have an error opening a device?

  // Lists of devices
  vrpn_Tracker	* trackers [VRPN_GSO_MAX_TRACKERS];
  int		num_trackers;
  vrpn_Button	* buttons [VRPN_GSO_MAX_BUTTONS];
  int		num_buttons;
  vrpn_Analog	* analogs [VRPN_GSO_MAX_ANALOG];
  int		num_analogs;

  void closeDevices (void);

  // iOS Device Setup
  int setup_iOSDevice (char * & pch, char * line, FILE * config_file);

};

#endif

